using System;

namespace Programme
{
    class Program
    {
        struct Point : IComparable<Point>
        {
            public long x, y;
            public Point(long x, long y)
            {
                this.x = x;
                this.y = y;
            }
            public int CompareTo(Point other)
            {
                if (x == other.x)
                {
                    return y.CompareTo(other.y);
                }
                else
                {
                    return x.CompareTo(other.x);
                }
            }
        }
        static long crossProduct(Point a, Point b, Point c)
        {
            return ((b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x));
        }
        static List<Point> edge(List<Point> points)
        {
            points.Sort();
            List<Point> bottom = new List<Point>();
            foreach (Point p in points)
            {
                while (bottom.Count >= 2 && (crossProduct(bottom[bottom.Count - 2], bottom[bottom.Count - 1], p) <= 0))
                {
                    bottom.RemoveAt(bottom.Count - 1);
                }
                bottom.Add(p);
            }
            List<Point> top = new List<Point>();
            for (int i = points.Count - 1; i  >= 0; i--)
            {
                while (top.Count >= 2 && (crossProduct(top[top.Count - 2], top[top.Count - 1], points[i]) <= 0))
                {
                    top.RemoveAt(top.Count - 1);
                }
                top.Add(points[i]);
            }
            bottom.RemoveAt(bottom.Count - 1);
            top.RemoveAt(top.Count - 1);
            bottom.AddRange(top);
            return bottom;
        }
        static long SurfaceArea(List<Point> edge)
        {
            long area = 0;
            int n = edge.Count;
            for (int i = 0; i < n; i++){
                long xA = edge[i].x;
                long yA = edge[i].y;
                long xB = edge[(i + 1) % n].x;
                long yB = edge[(i + 1) % n].y;
                area += xA * yB - xB * yA;
            }
            return Math.Abs(area)/2;
        }
        static void Main()
        {
            int n = Convert.ToInt32(Console.ReadLine());
            List<Point> points = new List<Point>();
            for (int i = 0; i < n; i++)
            {
                string[] s = Console.ReadLine().Split(' ');
                points.Add(new Point(Convert.ToInt32(s[0]), Convert.ToInt32(s[1])));
            }
            long minSurfaceArea = long.MaxValue;
            for (int i = 0; i < n; i++)
            {
                List<Point> currentList = points.Where((_, index) => index != i).ToList();
                currentList = edge(currentList);
                long tempArea = SurfaceArea(currentList);
                if (tempArea < minSurfaceArea)
                {
                    minSurfaceArea = tempArea;
                }
            }
            Console.WriteLine(minSurfaceArea);
        }
    }
}